<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:akcpa="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/AKC_PA.xsd" xmlns:ns1="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v4_0/AKC_PA.xsd" xmlns:ns2="http://www.w3.org/2000/09/xmldsig#" xmlns:ns3="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Types.xsd" xmlns:ns4="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Trader.xsd" xmlns:tp="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Types.xsd" xmlns:tr="http://www.e-clo.pl/ZEFIR2/eZefir2/xsd/v3_0/Trader.xsd" version="1.0"><xsl:decimal-format NaN="" decimal-separator="." grouping-separator=" "/><xsl:output encoding="UTF-8" method="html"/><xsl:template match="/"><xsl:apply-templates select="*"/></xsl:template><!-- POCZATEK ALL --><!-- STYL ARKUSZA --><xsl:template match="*" mode="styl1"><style type="text/css">body {margin:0;font-family:Verdana,Helvetica,sans-serif;font-size:10px;text-align:justify;}</style><style type="text/css">*{font-family:Verdana,Helvetica,sans-serif;padding:3px;color:black;}</style><style type="text/css">a{color:#3366FF;font-weight:bold;}</style><style type="text/css">h3{padding:3px;cursor:help;}</style><style type="text/css">h4,h5,.copyr{text-align:center;}</style><style type="text/css">caption{font-weight:bold;}</style><style type="text/css">table,div,td{font-size:8pt;border-color:black;}</style><style type="text/css">table{border-top:1 solid;border-bottom:2 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">th,td{border-top:1 solid;border-bottom:1 solid;border-left:1 solid;border-right:1 solid;}</style><style type="text/css">#cont{display:none}</style><style type="text/css">.copyr{background:#B1D8FF;font-weight:bold;}</style><style type="text/css">.nag1 {font-size: 20px; font-weight: bold;}</style><style type="text/css">.nag2{font-size: 20px}</style><style type="text/css">.cz10 {font-size: 10px}</style><style type="text/css">.cz12 {	font-size: 12px}</style><style type="text/css">.cz18 {font-size: 18px}</style><style type="text/css">.cz16 {font-size: 16px}</style><style type="text/css">.cz14 {font-size: 14px}</style></xsl:template><!-- SZABLON STOPKI --><xsl:template match="*" mode="stopka"><xsl:value-of select="name()"/></xsl:template><xsl:template match="*"><!-- ZASTOSOWANIE STYLU --><xsl:apply-templates mode="styl1" select="*"/><!-- DEKLARACJE AKCYZOWE --><xsl:apply-templates mode="dekl_AKCPA" select="."/></xsl:template><!-- SZABLON DOT. DEKLARACJI AKCYZOWYCH --><xsl:template match="*" mode="dekl_AKCPA"><xsl:for-each select=" ns1:Header |  ns4:* | akcpa:Header | tr:* "><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:apply-templates mode="Ident" select="."/><!-- SZABLON DLA RODZAJU DEKLARACJI --><xsl:apply-templates mode="rodz_dekl" select="."/><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:apply-templates mode="rok_mc" select="."/><!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --><xsl:apply-templates mode="PodstawaPrawna" select="."/><!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --><xsl:apply-templates mode="MiejsceDekl" select="."/><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:apply-templates mode="DanePodatnika" select="."/><!-- SZABLON DOT. ADRESU PODATNIKA --><xsl:apply-templates mode="Adres" select="."/><!-- SZABLON DOT. KWOTY PODATKU --><xsl:apply-templates mode="KwotaPodatku" select="."/><!-- SZABLON DOT. WYROBOW --><xsl:apply-templates mode="Wyroby" select="."/><!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --><xsl:apply-templates mode="OswPodatnika" select="."/><!-- SZABLON DOT. ADNOTACJI--><xsl:apply-templates mode="Adnotacje" select="."/><!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--><xsl:apply-templates mode="ObjasnieniaAkc" select="."/></xsl:for-each></xsl:template><!-- SZABLON DOT.  IDENTYFIKATORA PODATNIKA--><xsl:template match="*" mode="Ident"><table border="1" width="955"><tr align="left" valign="top"><td align="left" colspan="2" height="45" valign="middle" width="586"><span class="cz12"><b>1. Identyfikator podatkowy NIP podatnika </b></span></td><td align="center" colspan="2" valign="middle" width="353"><span class="nag2"><b><xsl:value-of select="@identifier"/></b></span></td></tr><tr align="left" colspan="1" valign="top"><td align="left" height="45" valign="top" width="353"/><td align="left" bgcolor="#CCCCCC" colspan="2" height="45" valign="top"><b>2. Nr dokumentu</b><br/><span class="cz16"><b><xsl:value-of select="@selfRef"/></b></span></td><td align="left" bgcolor="#CCCCCC" colspan="1" height="45" valign="top"><b>3. Status</b></td></tr></table></xsl:template><!-- SZABLON DOT.  RODZAJU DEKLARACJI --><xsl:template match="*" mode="rodz_dekl"><xsl:if test="ns1:* | akcpa:*"><table border="1" width="956"><tr><td colspan="3" height="40"><span class="nag1">AKC-PA (<xsl:value-of select="//@formKind"/>)<sup>1)</sup></span></td></tr><tr><td height="61" width="154"/><td width="537"><div align="center"><span class="nag1">DEKLARACJA W SPRAWIE PRZEDPŁATY AKCYZY</span></div></td><td width="243"/></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  OKRESU ROK MIESIAC --><xsl:template match="*" mode="rok_mc"><xsl:if test="ns1:* | akcpa:* "><table border="1" width="955"><tr><td height="49" width="247"/><td align="left" valign="top" width="135"><b>4. Miesiąc<sup>2)</sup></b><br/><div align="center" class="cz18"><xsl:value-of select="substring(@period,6,7)"/></div></td><td align="left" valign="top" width="131"><b>5. Rok<sup>2)</sup></b><br/><div align="center" class="cz18"><xsl:value-of select="substring(@period,1,4)"/></div></td><td width="206"/></tr></table></xsl:if></xsl:template><!-- SZABLON DOT.  PODSTAWY PRAWNEJ DLA DEKLARACJI --><xsl:template match="*" mode="PodstawaPrawna"><xsl:if test="ns1:* | akcpa:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td align="left" valign="top" width="115">Podstawa prawna: </td><td align="left" valign="top" width="824">Art. 22 ust. 1 pkt 1 ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym (Dz. U. z 2017 r. poz. 43, z późn. zm.).</td></tr><tr bgcolor="#CCCCCC"><td align="left" valign="top">Termin składania:</td><td align="left" valign="top">Do ostatniego dnia miesiąca poprzedzajacego miesiąc, w którym wyroby akcyzowe zostaną wyprodukowane.</td></tr><tr bgcolor="#CCCCCC"><td align="left" valign="top">Miejsce składania: </td><td align="left" valign="top">Urząd skarbowy, przy pomocy którego wykonuje swoje zadania naczelnik urzędu skarbowego właściwy ze względu na miejsce wykonywania czynności lub wystąpienia stanów faktycznych, podlegających opodatkowaniu akcyzą; jeżeli czynności podlegające opodatkowaniu akcyzą są wykonywane lub stany faktyczne podlegające opodatkowaniu akcyzą występują na obszarze właściwości miejscowej dwóch lub więcej naczelników urzędów skarbowych – zgodnie z art. 14 ust. 4 – 4f ustawy z dnia 6 grudnia 2008 r. o podatku akcyzowym; jeżeli właściwym organem podatkowym jest Naczelnik Trzeciego Urzędu Skarbowego Warszawa-Śródmieście w Warszawie, to miejscem składania jest Trzeci Urząd Skarbowy Warszawa-Śródmieście w Warszawie.</td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. MIEJSCE SKLADANIA DEKLARACJI --><xsl:template match="*" mode="MiejsceDekl"><xsl:if test="ns1:* | akcpa:*"><table border="1" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="3"><span class="nag1">A. WŁAŚCIWY ORGAN I CEL SKŁADANIA DEKLARACJI</span></td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="4" width="46"/><td colspan="2"><b>6.Naczelnik urzędu skarbowego</b><br/><span class="cz18"><xsl:value-of select="@taxOffice"/></span></td></tr><tr><td class="style3" colspan="2"><b>7. Cel złożenia formularza</b>(zaznaczyć własciwy kwadrat):  </td></tr><tr><td align="left" valign="top">1. złożenie deklaracji<br/><span class="cz18"><xsl:choose><xsl:when test="//@submissionAim='Deklaracja'"><b>X</b></xsl:when><xsl:otherwise><b/></xsl:otherwise></xsl:choose></span></td><td align="left" valign="top">2. korekta deklaracji<sup style="cz9">3)</sup><br/><span class="cz18"><xsl:choose><xsl:when test="//@submissionAim='Korekta'"><b>X</b><!--	<span class="cz10"> <xsl:value-of select="@justification"/> </span> --></xsl:when><xsl:otherwise><b/></xsl:otherwise></xsl:choose></span></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. DANYCH PODATNIKA --><xsl:template match="*" mode="DanePodatnika"><xsl:if test="ns1:* | akcpa:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag1">B. DANE PODATNIKA</span><br/> *- dotyczy podmiotów nie będących osobami fizycznymi **- dotyczy podmiotów będacych osobami fizycznymi </td></tr><tr bgcolor="#CCCCCC"><td colspan="4"><span class="nag2">B.1. DANE IDENTYFIKACYJNE</span></td></tr><tr><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td align="left" colspan="3" height="27" valign="top"><b>8. Rodzaj podatnika (zaznaczyć właściwy kwadrat): </b></td></tr><tr><td align="left" valign="top">1. podatnik niebędący osobą fizyczną <br/><xsl:for-each select=".//ns4:TaxpayerData | .//tr:TaxpayerData "><b><span class="cz18">X</span></b></xsl:for-each></td><td align="left" valign="top" width="425">2. osoba fizyczna <br/><xsl:for-each select=".//ns4:PrivatePerson | .//tr:PrivatePerson"><b><span class="cz18">X</span></b></xsl:for-each></td></tr><tr><td align="left" colspan="3" valign="top"><b>9. Nazwa pełna */Nazwisko, pierwsze imię, data urodzenia ** </b><br/><br/><span class="cz18"><xsl:value-of select="//@fullName"/></span><span class="cz18"><xsl:value-of select="//@REGON"/></span><span class="cz18"><xsl:value-of select="//@firstName"/></span><span class="cz18"><xsl:value-of select="//@surname"/></span><span class="cz18"><xsl:value-of select="//@dateOfBirth"/></span><span class="cz18"><xsl:value-of select="//@PESEL"/></span></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. ADRESU PODATNIKA --><xsl:template match="*" mode="Adres"><xsl:if test="ns1:* | akcpa:*"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td colspan="6"><span class="nag2">B.2. ADRES SIEDZIBY* / ADRES ZAMIESZKANIA**</span></td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td width="269"><b>10. Kraj </b><br/><br/><span class="cz18"><xsl:value-of select=".//@country"/></span></td><td colspan="2"><b>11. Województwo</b><br/><br/><span class="cz18"><xsl:value-of select=".//@provinceName"/></span></td><td colspan="2"><b>12. Powiat</b><br/><br/><span class="cz18"><xsl:value-of select=".//@districtName"/></span></td></tr><tr align="left" valign="top"><td><b>13. Gmina </b><br/><br/><span class="cz18"><xsl:value-of select=".//@communeName"/></span></td><td colspan="2"><b>14. Ulica</b><br/><br/><span class="cz18"><xsl:value-of select=".//@street"/></span></td><td width="144"><b>15. Nr domu</b><br/><br/><span class="cz18"><xsl:value-of select=".//@houseNumber"/></span></td><td width="151"><b>16. Nr lokalu</b><br/><br/><span class="cz18"><xsl:value-of select=".//@localNumber"/></span></td></tr><tr align="left" valign="top"><td><b>17. Miejscowość</b><br/><br/><span class="cz18"><xsl:value-of select=".//@city"/></span></td><td colspan="2"><b>18. Kod pocztowy</b><br/><br/><span class="cz18"><xsl:value-of select=".//@postalCode"/></span></td><td colspan="2"><b>19. Poczta</b><sup>(pole nieobowiązkowe)</sup><br/><br/><span class="cz18"><xsl:value-of select=".//@postalName"/></span></td><!-- <td colspan="2"> <b>Adres e-mail i nr telefonu</b> <br/> <span class="cz18"> <xsl:value-of select=".//@email"/>;</span> <br/> <span class="cz18"> <xsl:value-of select="@phone"/> </span> </td> --></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. KWOTY PODATKU --><xsl:template match="ns1:Header | akcpa:*" mode="KwotaPodatku"><table border="1" width="955"><tr bgcolor="#CCCCCC"><td class="nag1" colspan="4"><b>C. WYSOKOŚĆ PRZEDPŁATY AKCYZY </b></td></tr><tr><td bgcolor="#CCCCCC" rowspan="4" width="40"><p/><p/><p/><p/></td><td align="left" bgcolor="#CCCCCC" height="42" valign="top" width="610"><b>Kwota obliczonej przedpłaty akcyzy </b><br/><p>Kwota z pozycji 121.</p></td><td align="left" colspan="2" valign="top" width="283"><b>20.</b><br/><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(//@amountOfPrePayment),'# ##0')"/></div><div align="right" class="cz9" valign="bottom">zł</div></td></tr><tr><td align="left" bgcolor="#CCCCCC" height="46" valign="top"><b>Nadwyżka przedpłaty akcyzy </b><br/><p>Kwota nadwyżki przedpłaty wykazana w ostatniej złożonej deklaracji podatkowej.</p></td><td align="left" colspan="2" valign="top"><b>21.</b><br/><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(//@totalSurplusAmountOfPrePayment),'# ##0')"/></div><div align="right" class="cz9" valign="bottom">zł</div></td></tr><tr><td bgcolor="#CCCCCC"><b>Przedpłata akcyzy do zapłaty ***</b><br/><p>Od kwoty z poz. 20 należy odjąć kwotę z poz. 21; jeśli różnica jest liczbą ujemną, należy wpisać 0.</p></td><td align="left" colspan="2" valign="top"><b>22.</b><br/><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(//@toPay),'# ##0')"/></div><div align="right" class="cz9" valign="bottom">zł</div></td></tr></table><table width="955"><tr><td><sup>1)</sup>Dla każdej grupy wyrobów akcyzowych należy złożyć oddzielna deklaracje AKC-PA, wpisując w nawiasie w miejsce kropek odpowiednio literę: A, B, C, D, F, I, J lub K (przykładowo jeżeli przedpłata będzie dotyczyła produkcji piwa i zostanie uwzględniona w deklaracji AKC-4/C, w miejsce kropek należy wpisać literę C, natomiast jeżeli przedpłata będzie dotyczyła produkcji paliw silnikowych i zostanie uwzględniona w deklaracji AKC-4/D, w miejsce kropek należy wpisać literę D).<br/><sup>2)</sup>Należy wpisać miesiąc (i rok), w którym wyroby akcyzowe zostana wyprodukowane. <br/><sup>3)</sup> Zgodnie z art. 81 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa (Dz. U. z 2017 r. poz. 201).</td></tr></table><table width="955"><tr align="right" valign="top"><td colspan="3"><span class="nag1">AKC-PA (<xsl:value-of select="//@formKind"/>)</span><sub style="cz9">(7)</sub><b style="nag1">/1</b></td></tr></table></xsl:template><!-- SZABLON DOT. WYROBOW --><xsl:template match="ns1:* | akcpa:*" mode="Wyroby"><!-- ZNAK KONCA STRONY DO WYDRUKU --><div style="page-break-before: always"><!-- <table width="955" border="1"> <tr align="right" valign="top"> <td colspan="3"> <span class="nag1"><b><xsl:apply-templates select=".." mode = "stopka"/></b></span> </td> </tr> </table> --></div><table border="1" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td class="nag1" colspan="8">D. OBLICZENIE KWOTY PRZEDPŁATY AKCYZY </td></tr><tr align="center" bgcolor="#CCCCCC" valign="middle"><td>Lp.</td><td width="300">Nazwa grupy wyrobów, dla których ustalono odrębne stawki podatkowe </td><td width="60">Ośmiocyfrowy kod CN</td><td width="60">Podstawa obliczenia przedpłaty<sup>4)</sup></td><td width="100">Wartość wg maksymalnej ceny detalicznej (dotyczy papierosów i tytoniu do palenia)</td><td width="80">Średnia ważona detaliczna cena sprzedaży tytoniu do palenia obowiązująca w danym roku kalendarzowym (dotyczy wyrobów nowatorskich)</td><td width="79">Stawka podatku procentowa/ kwotowa/ minimalna<sup>5)</sup></td><td width="100">Kwota przedpłaty w zł</td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td><div align="center">a</div></td><td><div align="center">b</div></td><td><div align="center">c</div></td><td><div align="center">d</div></td><td><div align="center">e</div></td><td><div align="center">f</div></td><td><div align="center">g</div></td><td><div align="center">h</div></td></tr><xsl:for-each select="//ns1:Item | //akcpa:Item"><tr><td><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="@id"/></div></td><td><div align="left" class="cz14" valign="top"><xsl:value-of select="@groupOfGoodsName"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@codeCN"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@numberOfGoods"/></div><div align="right" class="cz18" valign="top"><xsl:value-of select="@unitOfMeasure"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@valueOfGoods"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="@weightedAverageRetailPrice"/></div></td><td><div align="right" class="cz18"><xsl:value-of select="@taxRatePercentage"/><br/> ______ </div><div align="right" class="cz18"><xsl:value-of select="@taxRate"/><br/> ______ </div><div align="right" class="cz18"><xsl:value-of select="@taxMin"/></div></td><td><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(@amountOfTax),'# ##0')"/></div></td></tr></xsl:for-each><tr align="left" valign="top"><td height="48"/><td bgcolor="#CCCCCC" colspan="6"><b>Razem: </b></td><td><b>121.</b><br/><div align="right" class="cz18" valign="top"><xsl:value-of select="format-number(number(//@sum),'# ##0')"/></div></td></tr></table><table width="955"><tr><td><sup>4)</sup> Ilość wyrobów w hektolitrach, w hektolitrach 100% vol. alkoholu etylowego, w hektolitrach x stopien Plato (% m/m ekstraktu brzeczki podstawowej), w kg, w tys. litrów, w tys. kilogramów, w tys. sztuk, w GJ, przy czym w przypadku hektolitrów i kilogramów ilość zaokrągla się z dokładnością do dwóch miejsc po przecinku, a w przypadku tysięcy litrów, tysięcy kilogramów, tysięcy sztuk i GJ ilość zaokrągla się z dokładnością do trzech miejsc po przecinku.<br/><sup>5)</sup> W polach oznaczonych numerem z literą „a” należy wpisać stawkę procentową, w polach oznaczonych numerem z literą „b” należy wpisać stawkę kwotową. </td></tr></table></xsl:template><!-- SZABLON DOT. OSWIADCZENIE PODATNIKA LUB OSOBY REPREZENTUJACEJ --><xsl:template match="*" mode="OswPodatnika"><xsl:if test="ns1:* | ns3:* | akcpa:* | tp:*"><table border="1" height="210" width="955"><tr align="left" bgcolor="#CCCCCC" valign="top"><td colspan="3"><b><span class="nag1">E. PODPIS PODATNIKA LUB OSOBY REPREZENTUJACEJ PODATNIKA</span></b><br/></td></tr><tr align="left" valign="top"><td bgcolor="#CCCCCC" rowspan="3" width="40"/><td height="37" width="402"><b>122. Imię </b><br/><br/><span class="cz18"><xsl:value-of select="//@repFirstName"/></span></td><td width="491"><b>123. Nazwisko </b><br/><br/><span class="cz18"><xsl:value-of select="//@repSurname"/></span></td></tr><tr align="left" valign="top"><td height="39"><b>124. Data wypełnienia deklaracji</b>(dzień-miesiąc-rok) <br/><br/><br/><span class="cz18"><xsl:value-of select="substring(//@declarationDate,9,2)"/><xsl:value-of select="substring(//@declarationDate,5,4)"/><xsl:value-of select="substring(//@declarationDate,1,4)"/></span></td><td><b>125. Podpis podatnika lub osoby reprezentującej podatnika </b></td></tr><tr align="left" valign="top"><td colspan="2" height="70"><b>126. Numer telefonu i adres e-mail podatnika lub osoby reprezentującej podatnika </b>(pole nieobowiązkowe) <br/><br/><span class="cz18"><xsl:value-of select="ns1:Statement/ns3:representative/@phone"/>, <xsl:value-of select="ns1:Statement/ns3:representative/@email"/></span></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. ADNOTACJI--><xsl:template match="*" mode="Adnotacje"><xsl:if test="ns1:* | akcpa:*"><table border="1" height="167" width="955"><tr bgcolor="#CCCCCC"><td colspan="3" height="36"><span class="nag1"> F. ADNOTACJE URZĘDU SKARBOWEGO </span><br/><span class="cz10">W przypadku deklaracji złożonej w wersji elektronicznej wypełnienie pól: 127, 128 i 129 nie jest obowiązkowe.</span></td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td rowspan="2" width="40"/><td colspan="2" height="72"><b>127. Uwagi urzędu skarbowego <br/><br/><br/><br/><br/><br/><br/></b></td></tr><tr align="left" bgcolor="#CCCCCC" valign="top"><td height="49" width="472"><b>128. Identyfikator przyjmujacego formularz <br/><br/><br/></b><p/></td><td width="421"><b> 129. Podpis przyjmującego formularz </b></td></tr></table></xsl:if></xsl:template><!-- SZABLON DOT. OBJASNIENIA I  POUCZENIA--><xsl:template match="*" mode="ObjasnieniaAkc"><xsl:if test="ns1:* | akcpa:*"><table width="955"><tr><td><p align="center"><b>Objasnienie</b></p> Podstawy opodatkowania (wyrażone kwotowo) i kwoty podatków zaokrągla się do pełnych złotych w ten sposób, że końcówki kwot wynoszące mniej niż 50 groszy pomija się, a końcówki kwot wynoszące 50 i więcej groszy podwyższa się do pełnych złotych – zgodnie z art. 63 § 1 ustawy z dnia 29 sierpnia 1997 r. – Ordynacja podatkowa. <p align="center"><b>Pouczenia</b></p> ***) W przypadku niewpłacenia w obowiązującym terminie kwoty z poz. 22 lub wpłacenia jej w niepełnej wysokości niniejsza deklaracja stanowi podstawę do wystawienia tytułu wykonawczego, zgodnie z przepisami ustawy z dnia 17 czerwca 1966 r. o postępowaniu egzekucyjnym w administracji (Dz. U. z 2016 r. poz. 599, z późn. zm.). <p/> Za podanie nieprawdy lub zatajenie prawdy i przez to narażenie podatku na uszczuplenie grozi odpowiedzialność przewidziana w Kodeksie karnym skarbowym. </td></tr><tr align="right" valign="top"><td colspan="3"><span class="nag1">AKC-PA (<xsl:value-of select="//@formKind"/>)</span><sub style="cz9">(7)</sub><b style="nag1">/2</b></td></tr></table></xsl:if></xsl:template><!-- KONIEC all AG--></xsl:stylesheet>